import { DEFAULT_SWR_OPTIONS } from "@/config/swr";
import useSWR, { mutate } from "swr";
import { listAllUsers } from "../lib/actions";

const INTERNAL__key = [
  "USE_LIST_ALL_USERS",
]

export function useListAllUsers() {
  return useSWR(INTERNAL__key,
    listAllUsers,
    DEFAULT_SWR_OPTIONS)
}

export function revalidateListAllUsers() {
  return mutate((k) => k === INTERNAL__key, undefined, ({
    populateCache(_, currentData) {
      return currentData
    },
    revalidate: true,
  }))
}
